#!/usr/bin/perl

# $Id: spt2txt.pl,v 1.2 2002/09/30 12:04:54 martin Exp $ 

while (<>) {
    chop;
    my ($Title, $AlternateTitle, $Description, $Url, $Source,
	$Relation, $Coverage, $Rights, $EmailAddress, $DateIssued,
	$DateOfRecordCreation, $DateRecordChecked, $DateLastModified,
	$VerificationAttempts, $ControlledName, $ControlledNameTypeName,
	$ClassificationName, $ClassificationTypeId) = split /\t/;
    print <<EOF;
Title: $Title
AlternateTitle: $AlternateTitle
Description: $Description
Url: $Url
Source: $Source
Relation: $Relation
Coverage: $Coverage
Rights: $Rights
EmailAddress: $EmailAddress
DateIssued: $DateIssued
DateOfRecordCreation: $DateOfRecordCreation
DateRecordChecked: $DateRecordChecked
DateLastModified: $DateLastModified
VerificationAttempts: $VerificationAttempts
ControlledName: $ControlledName
ControlledNameTypeName: $ControlledNameTypeName
ClassificationName: $ClassificationName
ClassificationTypeId: $ClassificationTypeId

EOF
}


=head1 NAME

B<spt2txt.pl> - Munge an SPT export into plain text

=head1 SYNOPSIS

  spt2txt.pl <spt.txt >plain.txt

=head1 DESCRIPTION

The B<spt2txt.pl> program takes a bulk export produced by the Scout
Portal Toolkit (SPT) software, and rewrites in a simple attribute
value text format, suitable for indexing by an arbtirary full text
searching package.

Note that the records in the resulting output are sent to STDOUT in a
single batch, delimited by blank lines.  Depending on the software in
use for indexing, it may be necessary to split them into separate
files (for example).

=head1 EXAMPLE

  $ cat wobble.spt
  The Man Who Mistook His Wife for a Hat          The Man Who Mistook
  His Wife for a Hat is populated by a cast as strange as that of the
  most fantastic fiction.  The subject of this strange and wonderful
  book is what happens when things go wrong with parts of the brain
  most of us don't know exist...  Dr Sacks shows the awesome powers
  of our mind and just how delicately balanced they have to be -
  Sunday Times.     http://www.irsociety.com/sacks.html
                             1985     1985    1985    1985    0

  $ spt2txt.pl <wobble.spt
  Title: The Man Who Mistook His Wife for a Hat
  AlternateTitle: 
  Description: The Man Who Mistook His Wife for a Hat is populated by
   a cast as strange as that of the most fantastic fiction.  The
   subject of this strange and wonderful book is what happens when
   things go wrong with parts of the brain most of us don't know
   exist...  Dr Sacks shows the awesome powers of our mind and just
   how delicately balanced they have to be - Sunday Times.
  Url: http://www.irsociety.com/sacks.html
  Source: 
  Relation: 
  Coverage: 
  Rights: 
  EmailAddress: 
  DateIssued: 1985
  DateOfRecordCreation: 1985
  DateRecordChecked: 1985
  DateLastModified: 1985
  VerificationAttempts: 0
  ControlledName: 
  ControlledNameTypeName: 
  ClassificationName: 
  ClassificationTypeId: 

=head1 SEE ALSO

L<spt2ldif.pl>, L<spt2iafa.pl>

=head1 COPYRIGHT

Copyright (c) 2002, Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>
All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

It was developed at the Department of Computer Science at Loughborough
University, as part of the joint JISC/NSF IMesh Toolkit project.

=head1 AUTHOR

Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>

