#!/usr/bin/perl

# $Id: spt2ldif.pl,v 1.2 2002/09/30 12:04:54 martin Exp $

$counter = 0;
$base = shift;

while (<>) {
    chop;
    my ($Handle) = time . "-$$-$counter";
    my ($Title, $AlternateTitle, $Description, $Url, $Source,
	$Relation, $Coverage, $Rights, $EmailAddress, $DateIssued,
	$DateOfRecordCreation, $DateRecordChecked, $DateLastModified,
	$VerificationAttempts, $ControlledName, $ControlledNameTypeName,
	$ClassificationName, $ClassificationTypeId) = split /\t/;

    print <<EOF;

dn: cn=$Handle,$base
objectClass: dublinCoreObject
cn: $Handle
dcTitle: $Title
dcTitle: $AlternateTitle
dcDescription: $Description
dcIdentifier: $Url
dcSource: $Source
dcRelation: $Relation
dcCoverage: $Coverage
dcRights: $Rights
dcCreator: $EmailAddress
dcDate: $DateIssued
dc$ControlledNameTypeName: $ControlledName
dcSubject: $ClassificationName

EOF

    $counter++;
}



=head1 NAME

B<spt2ldif.pl> - Munge an SPT export into LDIF

=head1 SYNOPSIS

  spt2ldif.pl <spt.txt >ldif.txt

=head1 DESCRIPTION

The B<spt2ldif.pl> program takes a bulk export produced by the Scout
Portal Toolkit (SPT) software, and rewrites it as a series of LDIF
records suitable for importing into an LDAP server.

An updated version of the LDIF (unqualified) Dublin Core schema
originally produced by the ROADS project is used.  The schema and the
output of this utility have been tested for compatibility with
OpenLDAP 2.0.23, and is included with the I<imeshtk-utils>
distribution archive for convenience.

For uniqueness, each record is given a commonName (effectively the
record ID) based on the current time, the process ID of the running
copy of B<spt2ldif.pl>, and a sequence number.

Note that you will almost certainly have to import the Dublin Core
schema before your LDAP software allows you to import the LDIF records
generated by this program.  With OpenLDAP this can be done by copying
the I<support/dublincore.schema> file into your LDAP schema directory
(e.g. I</etc/openldap/schema> on RedHat Linux) and updating your
I<slapd> config file to reference it, e.g.

  include         /etc/openldap/schema/dublincore.schema

For example, this file is I</etc/openldap/slapd.conf> by default on
RedHat Linux systems.  You may also prefer to index most or all of the
Dublin Core attributes:

  index dcTitle,dcCreator,dcSubject,dcDescription,dcPublisher,
    dcContributors,dcDate,dcType,dcFormat,dcIdentifier,dcSource,
    dcLanguage,dcRelation,dcCoverage,dcRights eq

Note that the above is word wrapped for clarity.  This should also go
into your I<slapd.conf>.

=head1 EXAMPLE

  $ cat wibble.spt
  Dan Leno and the Limehouse Golem                Set in pea-soup
  foggy Victorian London in the world of music hall and pantomime,
  Dan Leno and the Limehouse Golem begins with the death-by-hanging
  of Elizabeth Cree for the murder of her husband.  But was she
  guilty?  What terrible secret was she hiding? And what are we to
  make of the late Mr Cree whose journal begins: "It was a fine
  bright morning and I could feel a murder coming on?" I could feel
  those goosebumps coming on from page one ... this brilliant novel
  pervades the midnight movies of the mind and makes the blood run
  chilly - Daily Mail.
  http://www.futurenet.co.uk/Penguin/Authors/17.html
                               1994    1994   1994     1994    0

(SPT records use the tab character as a delimiter - but the above has
been word wrapped for readability)

   $ spt2ldif.pl 'dc=martinh,dc=net' <wibble.spt
  dn: cn=1033387250-16464-0,dc=martinh,dc=net
  objectClass: dublinCoreObject
  cn: 1033387250-16464-0
  dcTitle: Dan Leno and the Limehouse Golem
  dcTitle: 
  dcDescription: Set in pea-soup foggy Victorian London in the world
   of music hall and pantomime, Dan Leno and the Limehouse Golem
   begins with the death-by-hanging of Elizabeth Cree for the murder
   of her husband.  But was she guilty?  What terrible secret was she
   hiding? And what are we to make of the late Mr Cree whose journal
   begins: "It was a fine bright morning and I could feel a murder
   coming on?" I could feel those goosebumps coming on from page one
   ... this brilliant novel pervades the midnight movies of the mind
   and makes the blood run chilly - Daily Mail.
  dcIdentifier: http://www.futurenet.co.uk/Penguin/Authors/17.html
  dcSource: 
  dcRelation: 
  dcCoverage: 
  dcRights: 
  dcCreator: 
  dcDate: 1994
  dcSubject: 

=head1 SEE ALSO

L<ldif2spt.pl>

=head1 COPYRIGHT

Copyright (c) 2002, Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>
All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

It was developed at the Department of Computer Science at Loughborough
University, as part of the joint JISC/NSF IMesh Toolkit project.

=head1 AUTHOR

Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>

