#!/usr/bin/perl

# $Id: spt2iafa.pl,v 1.2 2002/09/30 12:04:54 martin Exp $

$counter = 0;

while (<>) {
    chop;
    my ($Handle) = time . "-$$-$counter";
    my ($Title, $AlternateTitle, $Description, $Url, $Source,
	$Relation, $Coverage, $Rights, $EmailAddress, $DateIssued,
	$DateOfRecordCreation, $DateRecordChecked, $DateLastModified,
	$VerificationAttempts, $ControlledName, $ControlledNameTypeName,
	$ClassificationName, $ClassificationTypeId) = split /\t/;

    print <<EOF;
Template-Type: DUBLINCORESIMPLE
Handle: $Handle
Title-v1: $Title
Title-v2: $AlternateTitle
Description-v1: $Description
Identifier-v1: $Url
Source-v1: $Source
Relation-v1: $Relation
Coverage-v1: $Coverage
Rights-v1: $Rights
Creator-v1: $EmailAddress
Date-v1: $DateIssued
$ControlledNameTypeName-v1: $ControlledName
Subject-v1: $ClassificationName

EOF

    $counter++;
}



=head1 NAME

B<spt2iafa.pl> - Munge an SPT export into IAFA (ROADS) templates

=head1 SYNOPSIS

  spt2iafa.pl <spt.txt >iafa.txt

=head1 DESCRIPTION

The B<spt2iafa.pl> program takes a bulk export produced by the Scout
Portal Toolkit (SPT) software, and rewrites it as a series of IAFA
templates suitable for loading into a ROADS server.

The ROADS DUBLINCORESIMPLE template type is used - this provides a
straightforward mechanism for the inclusion of unqualified Dublin Core
element sets within a ROADS database.  For uniqueness, each record is
given a handle (record ID) based on the current time, the process ID
of the running copy of B<spt2iafa.pl>, and a sequence number.

=head1 EXAMPLE

  $ head -1 foo.spt
  Microserfs              Microserfs takes us on-line into the
  brave new world of computer giant Microsoft.  There we meet the
  lost generation, struggling to get a life within a high-speed
  coroporate environment. It wasn't like this working for
  McDonald's.  The pay may be better. Your prestige may have risen.
  But somehow you're trapped on the corporate ladder, heading
  nowhere.  Your clothes are identical to everyone else's.  You
  shop in the same stores.  You aspire to the same things.  And
  however hard you work, however many shares you get, you're never
  going to be as rich as Bill.  You're a bug- checker in a software
  assembly line.  And besides, with the hours you're putting in,
  you're turning into a geek.  Your best relationships are on
  e-mail.  Something's got to give... http://www.coupland.com/
                             1995    1995    1995   1995     0

(SPT records use the tab character as a delimiter - but the above has
been word wrapped for readability)

  $ head -1 foo.spt | bin/spt2iafa.pl
  Template-Type: DUBLINCORESIMPLE
  Handle: 1033386734-16361-0
  Title-v1: Microserfs
  Title-v2: 
  Description-v1: Microserfs takes us on-line into the brave new
   world of computer giant Microsoft.  There we meet the lost
   generation, struggling to get a life within a high-speed
   coroporate environment. It wasn't like this working for
   McDonald's.  The pay may be better. Your prestige may have risen.
   But somehow you're trapped on the corporate ladder, heading
   nowhere.  Your clothes are identical to everyone else's.  You shop
   in the same stores.  You aspire to the same things.  And however
   hard you work, however many shares you get, you're never going to
   be as rich as Bill.  You're a bug- checker in a software assembly
   line.  And besides, with the hours you're putting in, you're turning
   into a geek.  Your best relationships are on e-mail.  Something's
   got to give...
  Identifier-v1: http://www.coupland.com/
  Source-v1: 
  Relation-v1: 
  Coverage-v1: 
  Rights-v1: 
  Creator-v1: 
  Date-v1: 1995
  Subject-v1: 

=head1 SEE ALSO

L<iafa2spt.pl>

=head1 COPYRIGHT

Copyright (c) 2002, Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>
All rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

It was developed at the Department of Computer Science at Loughborough
University, as part of the joint JISC/NSF IMesh Toolkit project.

=head1 AUTHOR

Martin Hamilton E<lt>imeshtk-utils@martinh.netE<gt>

