#!/usr/bin/perl-5.6.1

use lib "../";  ## the location of the imesh RSSReadingList module
# standard Perl modules
use CGI;
use XML::Simple;
use RSSReadingList;

## this script gets a list of URLs each of which retrieves a record in XML format,
## (the XML format should conform to the OAI-dc schema) form the user
## the script uses the RSSReadingList module to 
## get the record from the repository and extract values for each
## of the URLS for the items that will appear in the RSS
## it then uses RSSReadingList to generate an
## RSS format of the reading list, including any list descriptions given by the user.
## the RSS is saved to file - the user supplies the name of the file
## and other rss data needed eg channel title, description
## (this is usually done through a web form integrated with the subject gateway service)
## Monica Duke, UKOLN, June 2003

## Acknowledgements: RSSReadingList based on code by P.Cliff and A.Powell of UKOLN

my $cgi = new CGI;

# could check that you get valid URLs and that there is at least one...

@URLS = $cgi->param('oaiid');
$oaiversion = $cgi->param('oaiver') || 1; # should be 1 or 2, assume 1 for now
# get other params from form and store in hash

## you should also do something here to catch errors
## and some basic testing for minimal list information

$otherparams{ctitle} = $cgi->param('ctitle') || "";
$otherparams{clink} = $cgi->param('clink') || "";
$otherparams{cdesc} = $cgi->param('cdesc') || "";
$otherparams{clang} = $cgi->param('clang') || "";
$otherparams{ccopyright} = $cgi->param('ccopyright') || "";
$otherparams{cwebmaster} = $cgi->param('cwebmaster') || "";
$otherparams{iurl} = $cgi->param('iurl') || "";
$otherparams{ititle} = $cgi->param('ititle') || "";
$otherparams{ilink} = $cgi->param('ilink') || "";
$otherparams{tititle} = $cgi->param('tititle') || "";
$otherparams{tilink} = $cgi->param('tilink') || "";
$otherparams{tidesc} = $cgi->param('tidesc') || "";
$otherparams{tiname} = $cgi->param('tiname') || "";
#$otherparams{} = $cgi->param('') || "";

# get item values
 
($items, $errors) = getItemValuesFromOai($oaiversion, \@URLS);

## do something with the errors..
if (keys %{$errors}) {
  print $cgi->header;
  print "<H1>Some errors were encountered:</H1>";
  foreach $url (keys %{$errors}){
    print "$url: $errors->{$url}<br />";
  }
} else {
# generate RSS
$rss = generate_RSS($items, \%otherparams);


print <<EOF;
Content-type: text/xml
Content-Disposition: attachment; filename=rss.xml

EOF
print $rss;
}
